/****************************************************************************
* Donohue and Wolfers (2006) 
* Table 6
* Estimating the Impact of Executions on Murder Rates: 
* Reanalyzing Mocan and Gittings: 1977-1997
****************************************************************************/


clear
set more off
set mem 500m
set mat 800
cd "..."

use "FG.dta", clear
do "fips to st.do"
drop state* trend* time*
tsset fips year
replace cmurrat=cmurrat*100

gen exrate=expro/l6.sentcX /* if l6.sentc>0 | expro==0 */
gen pardrate=pardpro/l6.sentcX /* if l6.sentc>0 | pardpro==0*/
gen removalrate=removalpro/l5.sentcX /*if l5.sentc>0 | removalpro==0*/
gen arrestrt=amur/cmur
gen sentrt=sentc/l2.amur
gen custody=prison/cviol
gen deathrate=(pdeath/prison)*1000
gen exrate5=expro/l5.sentcX /* if l5.sentc>0 | expro==0*/

* Panel A
xi: regress cmurrat l.exrate l.arrestrt l.sentrt l.custody l.deathrate perblk repub unemp realinc mortal urban legal18 legal19 legal20 rat2034 rat3544 rat4554 rat55 i.st*year i.year ok95 [aweight=pop] if l6.sentc>0 | expro==0, robust cluster(st)
lincom -(_b[l.exrate]*(38/258)*(229300000/100000/38))-1
lincom -((_b[l.exrate]+1.96*_se[l.exrate])*(38/258)*(229300000/100000/38))-1
lincom -((_b[l.exrate]-1.96*_se[l.exrate])*(38/258)*(229300000/100000/38))-1
xi: regress cmurrat l.pardrate l.arrestrt l.sentrt l.custody l.deathrate perblk repub unemp realinc mortal urban legal18 legal19 legal20 rat2034 rat3544 rat4554 rat55 i.st*year i.year ok95 [aweight=pop] if l6.sentc>0 | pardpro==0, robust cluster(st)
xi: regress cmurrat l.removalrate l.arrestrt l.sentrt l.custody l.deathrate perblk repub unemp realinc mortal urban legal18 legal19 legal20 rat2034 rat3544 rat4554 rat55 i.st*year i.year ok95 [aweight=pop] if l5.sentc>0 | removalpro==0, robust cluster(st)
xi: regress cmurrat l.exrate l.pardrate l.arrestrt l.sentrt l.custody l.deathrate perblk repub unemp realinc mortal urban legal18 legal19 legal20 rat2034 rat3544 rat4554 rat55 i.st*year i.year ok95 [aweight=pop] if (l6.sentc>0 | expro==0) & (l6.sentc>0 | pardpro==0), robust cluster(st)
lincom -(_b[l.exrate]*(38/258)*(229300000/100000/38))-1
lincom -((_b[l.exrate]+1.96*_se[l.exrate])*(38/258)*(229300000/100000/38))-1
lincom -((_b[l.exrate]-1.96*_se[l.exrate])*(38/258)*(229300000/100000/38))-1
xi: regress cmurrat l.exrate5 l.removalrate l.arrestrt l.sentrt l.custody l.deathrate perblk repub unemp realinc mortal urban legal18 legal19 legal20 rat2034 rat3544 rat4554 rat55 i.st*year i.year ok95 [aweight=pop] if (l5.sentc>0 | expro==0) & (l5.sentc>0 | removalpro==0), robust cluster(st)
lincom -(_b[l.exrate]*(38/258)*(229300000/100000/38))-1
lincom -((_b[l.exrate]+1.96*_se[l.exrate])*(38/258)*(229300000/100000/38))-1
lincom -((_b[l.exrate]-1.96*_se[l.exrate])*(38/258)*(229300000/100000/38))-1
gen lncmurrat=ln(cmurrat)
xi: regress lncmurrat l.exrate l.pardrate l.arrestrt l.sentrt l.custody l.deathrate perblk repub unemp realinc mortal urban legal18 legal19 legal20 rat2034 rat3544 rat4554 rat55 i.st*year i.year ok95 [aweight=pop] if (l6.sentc>0 | expro==0) & (l6.sentc>0 | pardpro==0), robust cluster(st)
lincom -(_b[l.exrate]*(38/258))*(17716/38)-1
lincom -((_b[l.exrate]+1.96*_se[l.exrate])*(38/258))*(17716/38)-1
lincom -((_b[l.exrate]-1.96*_se[l.exrate])*(38/258))*(17716/38)-1
xi: regress lncmurrat l.exrate5 l.removalrate l.arrestrt l.sentrt l.custody l.deathrate perblk repub unemp realinc mortal urban legal18 legal19 legal20 rat2034 rat3544 rat4554 rat55 i.st*year i.year ok95 [aweight=pop] if (l5.sentc>0 | expro==0) & (l5.sentc>0 | removalpro==0), robust cluster(st)
lincom -(_b[l.exrate]*(38/258))*(17716/38)-1
lincom -((_b[l.exrate]+1.96*_se[l.exrate])*(38/258))*(17716/38)-1
lincom -((_b[l.exrate]-1.96*_se[l.exrate])*(38/258))*(17716/38)-1

* Panel B
drop exrate pardrate removalrate arrestrt sentrt custody deathrate exrate5
gen exrate=expro/l6.sentcX if l6.sentc>0 | expro==0
gen pardrate=pardpro/l6.sentcX if l6.sentc>0 | pardpro==0
gen removalrate=removalpro/l5.sentcX if l5.sentc>0 | removalpro==0
gen arrestrt=amur/cmur
gen sentrt=sentc/l2.amur
gen custody=prison/cviol
gen deathrate=(pdeath/prison)*1000
gen exrate5=expro/l6.sentcX  if l6.sentc>0 | expro==0

xi: regress cmurrat l.exrate l.arrestrt l.sentrt l.custody l.deathrate perblk repub unemp realinc mortal urban legal18 legal19 legal20 rat2034 rat3544 rat4554 rat55 i.st*year i.year ok95 [aweight=pop] , robust cluster(st)
lincom -(_b[l.exrate]*(38/258)*(229300000/100000/38))-1
lincom -((_b[l.exrate]+1.96*_se[l.exrate])*(38/258)*(229300000/100000/38))-1
lincom -((_b[l.exrate]-1.96*_se[l.exrate])*(38/258)*(229300000/100000/38))-1
xi: regress cmurrat l.pardrate l.arrestrt l.sentrt l.custody l.deathrate perblk repub unemp realinc mortal urban legal18 legal19 legal20 rat2034 rat3544 rat4554 rat55 i.st*year i.year ok95 [aweight=pop] , robust cluster(st)
xi: regress cmurrat l.removalrate l.arrestrt l.sentrt l.custody l.deathrate perblk repub unemp realinc mortal urban legal18 legal19 legal20 rat2034 rat3544 rat4554 rat55 i.st*year i.year ok95 [aweight=pop] , robust cluster(st)
xi: regress cmurrat l.exrate l.pardrate l.arrestrt l.sentrt l.custody l.deathrate perblk repub unemp realinc mortal urban legal18 legal19 legal20 rat2034 rat3544 rat4554 rat55 i.st*year i.year ok95 [aweight=pop] , robust cluster(st)
lincom -(_b[l.exrate]*(38/258)*(229300000/100000/38))-1
lincom -((_b[l.exrate]+1.96*_se[l.exrate])*(38/258)*(229300000/100000/38))-1
lincom -((_b[l.exrate]-1.96*_se[l.exrate])*(38/258)*(229300000/100000/38))-1
xi: regress cmurrat l.exrate5 l.removalrate l.arrestrt l.sentrt l.custody l.deathrate perblk repub unemp realinc mortal urban legal18 legal19 legal20 rat2034 rat3544 rat4554 rat55 i.st*year i.year ok95 [aweight=pop], robust cluster(st)
lincom -(_b[l.exrate]*(38/258)*(229300000/100000/38))-1
lincom -((_b[l.exrate]+1.96*_se[l.exrate])*(38/258)*(229300000/100000/38))-1
lincom -((_b[l.exrate]-1.96*_se[l.exrate])*(38/258)*(229300000/100000/38))-1
xi: regress lncmurrat l.exrate l.pardrate l.arrestrt l.sentrt l.custody l.deathrate perblk repub unemp realinc mortal urban legal18 legal19 legal20 rat2034 rat3544 rat4554 rat55 i.st*year i.year ok95 [aweight=pop] , robust cluster(st)
lincom -(_b[l.exrate]*(38/258))*(17716/38)-1
lincom -((_b[l.exrate]+1.96*_se[l.exrate])*(38/258))*(17716/38)-1
lincom -((_b[l.exrate]-1.96*_se[l.exrate])*(38/258))*(17716/38)-1
xi: regress lncmurrat l.exrate5 l.removalrate l.arrestrt l.sentrt l.custody l.deathrate perblk repub unemp realinc mortal urban legal18 legal19 legal20 rat2034 rat3544 rat4554 rat55 i.st*year i.year ok95 [aweight=pop] , robust cluster(st)
lincom -(_b[l.exrate]*(38/258))*(17716/38)-1
lincom -((_b[l.exrate]+1.96*_se[l.exrate])*(38/258))*(17716/38)-1
lincom -((_b[l.exrate]-1.96*_se[l.exrate])*(38/258))*(17716/38)-1

* Panel C
drop exrate pardrate removalrate arrestrt sentrt custody deathrate exrate5
gen exrate=expro/sentcX if sentc>0 | expro==0
gen pardrate=pardpro/sentcX if sentc>0 | pardpro==0
gen removalrate=removalpro/sentcX if sentc>0 | removalpro==0
gen arrestrt=amur/cmur
gen sentrt=sentc/amur
gen custody=prison/cviol
gen deathrate=(pdeath/prison)*1000
gen exrate5=expro/sentcX  if sentc>0 | expro==0

xi: regress cmurrat l.exrate l.arrestrt l.sentrt l.custody l.deathrate perblk repub unemp realinc mortal urban legal18 legal19 legal20 rat2034 rat3544 rat4554 rat55 i.st*year i.year ok95 [aweight=pop] , robust cluster(st)
lincom -(_b[l.exrate]*(38/320)*(229300000/100000/38))-1
lincom -((_b[l.exrate]+1.96*_se[l.exrate])*(38/320)*(229300000/100000/38))-1
lincom -((_b[l.exrate]-1.96*_se[l.exrate])*(38/320)*(229300000/100000/38))-1
xi: regress cmurrat l.pardrate l.arrestrt l.sentrt l.custody l.deathrate perblk repub unemp realinc mortal urban legal18 legal19 legal20 rat2034 rat3544 rat4554 rat55 i.st*year i.year ok95 [aweight=pop] , robust cluster(st)
xi: regress cmurrat l.removalrate l.arrestrt l.sentrt l.custody l.deathrate perblk repub unemp realinc mortal urban legal18 legal19 legal20 rat2034 rat3544 rat4554 rat55 i.st*year i.year ok95 [aweight=pop] , robust cluster(st)
xi: regress cmurrat l.exrate l.pardrate l.arrestrt l.sentrt l.custody l.deathrate perblk repub unemp realinc mortal urban legal18 legal19 legal20 rat2034 rat3544 rat4554 rat55 i.st*year i.year ok95 [aweight=pop] , robust cluster(st)
lincom -(_b[l.exrate]*(38/320)*(229300000/100000/38))-1
lincom -((_b[l.exrate]+1.96*_se[l.exrate])*(38/320)*(229300000/100000/38))-1
lincom -((_b[l.exrate]-1.96*_se[l.exrate])*(38/320)*(229300000/100000/38))-1
xi: regress cmurrat l.exrate5 l.removalrate l.arrestrt l.sentrt l.custody l.deathrate perblk repub unemp realinc mortal urban legal18 legal19 legal20 rat2034 rat3544 rat4554 rat55 i.st*year i.year ok95 [aweight=pop], robust cluster(st)
lincom -(_b[l.exrate]*(38/320)*(229300000/100000/38))-1
lincom -((_b[l.exrate]+1.96*_se[l.exrate])*(38/320)*(229300000/100000/38))-1
lincom -((_b[l.exrate]-1.96*_se[l.exrate])*(38/320)*(229300000/100000/38))-1
xi: regress lncmurrat l.exrate l.pardrate l.arrestrt l.sentrt l.custody l.deathrate perblk repub unemp realinc mortal urban legal18 legal19 legal20 rat2034 rat3544 rat4554 rat55 i.st*year i.year ok95 [aweight=pop] , robust cluster(st)
lincom -(_b[l.exrate]*(38/320))*(17716/38)-1
lincom -((_b[l.exrate]+1.96*_se[l.exrate])*(38/320))*(17716/38)-1
lincom -((_b[l.exrate]-1.96*_se[l.exrate])*(38/320))*(17716/38)-1
xi: regress lncmurrat l.exrate5 l.removalrate l.arrestrt l.sentrt l.custody l.deathrate perblk repub unemp realinc mortal urban legal18 legal19 legal20 rat2034 rat3544 rat4554 rat55 i.st*year i.year ok95 [aweight=pop] , robust cluster(st)
lincom -(_b[l.exrate]*(38/320))*(17716/38)-1
lincom -((_b[l.exrate]+1.96*_se[l.exrate])*(38/320))*(17716/38)-1
lincom -((_b[l.exrate]-1.96*_se[l.exrate])*(38/320))*(17716/38)-1

